	function PLOT_PHASE_DIFF_Z(wT, Phase, minPhase, maxPhase)
	
	% Plots the phase response for an allpass filter.
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2005-05-07
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs: 
	% Report bugs to:	larsw@isy.liu.se
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font sizePhase2
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	hold on;
	plot(wT, Phase,'linewidth', lw);	
	N = length(Phase);
	Diff = Phase(1:N-1) - Phase(2:N);

	axis([0 max(wT) minPhase maxPhase]);
	ylabel('{\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	%	ylabel('{\it\Delta\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);

	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax,lab);

	
	ay = [-4*pi -3*pi -2*pi -pi 0];	 
	laby = {'-4\pi';'-3\pi';'-2\pi';'-\pi';'0'};
	
	
	ytick(ay,laby); 
	grid on;
	box on;
		
